/*
 * Settings.cpp
 *
 *  Created on: 30.10.2009
 *      Author: stefan.detter
 */

#include "Settings.h"

#include <QSettings>
#include <QVariant>

#include <def.h>

Settings 	Settings::m_instance;
Settings* 	Settings::d = &Settings::m_instance;

Settings::Settings()
{
	m_settings = new QSettings(QSettings::IniFormat, QSettings::UserScope, COMPANY_NAME, "Reader Suite");

	m_refreshRate = 100;

	m_attachReaderAutomatically = true;

	m_multiplexOn = false;
	m_multiplexTime = 500;

    m_parseTagIds = false;
    m_asciiTagIds = false;

	m_ttlOn = true;
	m_ttlInactive = 2000;
	m_ttlOutOfRange = 5000;
	m_ttlDelete = 15000;

	m_readBeep = false;
	m_readBeepType = 0;
	m_readBeepParallel = 10;

	m_traceOn = false;
	m_traceLevel = 0;

	readSettings();
}

Settings::~Settings()
{
	storeSettings();
	delete m_settings;
}


void Settings::readSettings()
{
	m_settings->beginGroup("Visual");
	m_refreshRate =		m_settings->value("RefreshRate", 	m_refreshRate).toUInt();
	m_settings->endGroup();

	m_settings->beginGroup("Reader");
	m_attachReaderAutomatically =		m_settings->value("AttachAutomatically", 	m_attachReaderAutomatically).toBool();
	m_settings->endGroup();

	m_settings->beginGroup("Multiplex");
	m_multiplexOn =		m_settings->value("MultiplexOn", 	m_multiplexOn).toBool();
	m_multiplexTime =	m_settings->value("MultiplexTime", 	m_multiplexTime).toUInt();
	m_settings->endGroup();

    m_settings->beginGroup("TagId");
    m_parseTagIds =		m_settings->value("Parse", 			m_parseTagIds).toBool();
    m_asciiTagIds =		m_settings->value("Ascii", 			m_asciiTagIds).toBool();
    m_settings->endGroup();

	m_settings->beginGroup("TTL");
	m_ttlOn =			m_settings->value("TTLOn", 			m_ttlOn).toBool();
	m_ttlInactive =		m_settings->value("TTLInactive", 	m_ttlInactive).toUInt();
	m_ttlOutOfRange =	m_settings->value("TTLOutOfRange", 	m_ttlOutOfRange).toUInt();
	m_ttlDelete =		m_settings->value("TTLDelete", 		m_ttlDelete).toUInt();
	m_settings->endGroup();

	m_settings->beginGroup("TagReadAction");
	m_readBeep =		m_settings->value("Beep",			m_readBeep).toBool();
	m_readBeepType =	m_settings->value("BeepType",		m_readBeepType).toUInt();
	m_readBeepType =	m_settings->value("BeepParallel",	m_readBeepParallel).toUInt();
	m_settings->endGroup();
}

void Settings::storeSettings()
{
	m_settings->beginGroup("Visual");
	m_settings->setValue("RefreshRate", 	m_refreshRate);
	m_settings->endGroup();

	m_settings->beginGroup("Reader");
	m_settings->setValue("AttachAutomatically", 	m_attachReaderAutomatically);
	m_settings->endGroup();

	m_settings->beginGroup("Multiplex");
	m_settings->setValue("MultiplexOn", 	m_multiplexOn);
	m_settings->setValue("MultiplexTime", 	m_multiplexTime);
	m_settings->endGroup();

    m_settings->beginGroup("TagId");
    m_settings->setValue("Parse", 			m_parseTagIds);
    m_settings->setValue("Ascii", 			m_asciiTagIds);
    m_settings->endGroup();

	m_settings->beginGroup("TTL");
	m_settings->setValue("TTLOn", 			m_ttlOn);
	m_settings->setValue("TTLInactive", 	m_ttlInactive);
	m_settings->setValue("TTLOutOfRange", 	m_ttlOutOfRange);
	m_settings->setValue("TTLDelete", 		m_ttlDelete);
	m_settings->endGroup();

	m_settings->beginGroup("TagReadAction");
	m_settings->setValue("Beep", 			m_readBeep);
	m_settings->setValue("BeepType", 		m_readBeepType);
	m_settings->setValue("BeepParallel", 	m_readBeepType);
	m_settings->endGroup();
}



uint Settings::refreshRate() const
{
	return m_refreshRate;
}

bool Settings::attachReaderAutomatically() const
{
	return m_attachReaderAutomatically;
}

bool Settings::multiplexOn() const
{
	return m_multiplexOn;
}

uint Settings::multiplexTime() const
{
	return m_multiplexTime;
}

bool Settings::parseTagIds() const
{
    return m_parseTagIds;
}

bool Settings::showTagIdAscii() const
{
    return m_asciiTagIds;
}

bool Settings::ttlOn() const
{
	return m_ttlOn;
}

uint Settings::ttlInactive() const
{
	return m_ttlInactive;
}

uint Settings::ttlOutOfRange() const
{
	return m_ttlOutOfRange;
}

uint Settings::ttlDelete() const
{
	return m_ttlDelete;
}

bool Settings::readBeepOn() const
{
	return m_readBeep;
}

uint Settings::readBeepType() const
{
	return m_readBeepType;
}

uint Settings::readBeepParallel() const
{
	return m_readBeepParallel;
}


bool Settings::traceOn() const
{
	return m_traceOn;
}

int Settings::traceLevel() const
{
	return m_traceLevel;
}


void Settings::setRefreshRate(uint rate)
{
	m_refreshRate = rate;
}

void Settings::setAttachReaderAutomatically(bool on)
{
	m_attachReaderAutomatically = on;
	emit automaticallyAttachChanged(on);
}

void Settings::setMultiplexOn(bool on)
{
	m_multiplexOn = on;
}

void Settings::setMultiplexTime(uint time)
{
	m_multiplexTime = time;
}

void Settings::setParseTagIds(bool parseTagIds)
{
    m_parseTagIds = parseTagIds;
}

void Settings::setShowTagIdAscii(bool asciiTagIds)
{
    m_asciiTagIds = asciiTagIds;
}

void Settings::setTtlOn(bool on)
{
	m_ttlOn = on;
}

void Settings::setTtlInactive(uint time)
{
	m_ttlInactive = time;
}

void Settings::setTtlOutOfRange(uint time)
{
	m_ttlOutOfRange = time;
}

void Settings::setTtlDelete(uint time)
{
	m_ttlDelete = time;
}

void Settings::setReadBeep(bool on)
{
	if(m_readBeep == on)
		return;
	m_readBeep = on;

	emit readBeepChanged(m_readBeep);
}

void Settings::setReadBeepType(uint type)
{
	if(m_readBeepType == type)
		return;
	m_readBeepType = type;

	emit readBeepChanged(m_readBeep);
}

void Settings::setReadBeepParallel(uint parallel)
{
	if(m_readBeepParallel == parallel)
		return;
	m_readBeepParallel = parallel;

	emit readBeepChanged(m_readBeep);
}

void Settings::setTraceOn(bool on)
{
	m_traceOn = on;
}

void Settings::setTraceLevel(int level)
{
	m_traceLevel = level;
}


